<?php
/**
 * Transfer Character
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

echo '<div class="page-title"><span>'.lang('transfercharacter_title',true).'</span></div>';

try {
	
	$TransferCharacter = new \Plugin\TransferCharacter\TransferCharacter();
	$TransferCharacter->setUsername($_SESSION['username']);
	$AccountCharacters = $TransferCharacter->getAccountCharacterList();
	$Character = new Character();
	
	if(check_value($_GET['success'])) {
		message('success', lang('transfercharacter_success_1'));
	}
	
	if(check_value($_GET['character'])) {
		
		// Selected Character
		if(!in_array($_GET['character'], $AccountCharacters)) throw new Exception(lang('transfercharacter_error_6'));
		
		// Submit
		if(check_value($_POST['submit'])) {
			try {
				
				if($_POST['character'] != $_GET['character']) throw new Exception(lang('transfercharacter_error_6'));
				$TransferCharacter->setUserid($_SESSION['userid']);
				$TransferCharacter->setCharacter($_POST['character']);
				$TransferCharacter->setTransferId($_POST['transfer_id']);
				$TransferCharacter->transfer();
				
			} catch(Exception $ex) {
				message('error', $ex->getMessage());
			}
		}
		
		echo '<table class="table general-table-ui">';
			echo '<tr>';
				echo '<td></td>';
				echo '<td>'.lang('transfercharacter_txt_1',true).'</td>';
				echo '<td>'.lang('transfercharacter_txt_3',true).'</td>';
				echo '<td></td>';
			echo '</tr>';
			
			$characterData = $Character->CharacterData($_GET['character']);
			$characterIMG = $Character->GenerateCharacterClassAvatar($characterData[_CLMN_CHR_CLASS_]);
			
			echo '<form action="'.__TRANSFERCHARACTER_HOME__.'character/'.$characterData[_CLMN_CHR_NAME_].'" method="post">';
				echo '<input type="hidden" name="character" value="'.$characterData[_CLMN_CHR_NAME_].'"/>';
				echo '<tr>';
					echo '<td>'.$characterIMG.'</td>';
					echo '<td>'.$characterData[_CLMN_CHR_NAME_].'</td>';
					echo '<td><input type="text" class="form-control" name="transfer_id" required autofocus/></td>';
					echo '<td><button type="submit" name="submit" value="submit" class="btn btn-primary">'.lang('transfercharacter_txt_2',true).'</button></td>';
				echo '</tr>';
			echo '</form>';
		echo '</table>';
		
	} else {
		
		// Character List
		message('info', langf('transfercharacter_txt_6', array($TransferCharacter->generateTransferId($_SESSION['userid']))));
		
		echo '<table class="table general-table-ui">';
			echo '<tr>';
				echo '<td></td>';
				echo '<td>'.lang('transfercharacter_txt_1',true).'</td>';
				echo '<td></td>';
			echo '</tr>';
			foreach($AccountCharacters as $row) {
				$characterData = $Character->CharacterData($row);
				$characterIMG = $Character->GenerateCharacterClassAvatar($characterData[_CLMN_CHR_CLASS_]);
				echo '<tr>';
					echo '<td>'.$characterIMG.'</td>';
					echo '<td>'.$characterData[_CLMN_CHR_NAME_].'</td>';
					echo '<td><a href="'.__TRANSFERCHARACTER_HOME__.'character/'.$characterData[_CLMN_CHR_NAME_].'" class="btn btn-primary">'.lang('transfercharacter_txt_2',true).'</a></td>';
				echo '</tr>';
			}
		echo '</table>';
		
	}
	
	echo '<div class="module-requirements text-center">';
		echo '<p>'.langf('transfercharacter_txt_4', array($TransferCharacter->getCost())).'</p>';
		echo '<p>'.lang('transfercharacter_txt_5').'</p>';
		if($TransferCharacter->getRequiredLevel() > 0) echo '<p>'.langf('transfercharacter_txt_7', array($TransferCharacter->getRequiredLevel())).'</p>';
		if($TransferCharacter->getRequiredMasterLevel() > 0) echo '<p>'.langf('transfercharacter_txt_8', array($TransferCharacter->getRequiredMasterLevel())).'</p>';
		if($TransferCharacter->getRequiredResets() > 0) echo '<p>'.langf('transfercharacter_txt_9', array($TransferCharacter->getRequiredResets())).'</p>';
	echo '</div>';
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}